% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_metrics.R
\name{grid_metrics}
\alias{grid_metrics}
\title{Split an image into grid and calculates a metric for each grid square}
\usage{
grid_metrics(spe_object, FUN, n_split, ...)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{FUN}{Variable name specifying the metric to be calculated.}

\item{n_split}{Integer specifying the number of splits for the calculation of
metrics. This number is the splits on each side (e.g. `n_split` = 3 means
the image will be split into 9 tiles.)}

\item{...}{Arguments of FUN}
}
\value{
A list of the metrics of all grid tiles
}
\description{
Calculates a specified metric for each grid tile in the image
  and plots the metrics for the grid tiles.
}
\examples{
grid <- grid_metrics(SPIAT::defined_image, FUN = calculate_entropy, n_split = 5,
cell_types_of_interest=c("Tumour","Immune3"), feature_colname = "Cell.Type")
}
