% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_inform_to_spe.R
\name{format_inform_to_spe}
\alias{format_inform_to_spe}
\title{Format an inForm image into a SpatialExperiment object}
\usage{
format_inform_to_spe(
  path,
  markers,
  locations = NULL,
  intensity_columns_interest = NULL
)
}
\arguments{
\item{path}{String of the path location of inForm text file.}

\item{markers}{String Vector containing the markers used for staining.}

\item{locations}{(Optional) String Vector containing the locations of markers
used for staining. Location can be either "Nucleus", "Cytoplasm" or
"Membrane". This is used to select the Intensity column and can be used
instead of `intensity_columns_interest`.}

\item{intensity_columns_interest}{(Optional) Use if `locations` is not
specified. Vector with the names of the columns with the level of each
marker. Column names must match the order of the 'markers' parameter.}
}
\value{
A SpatialExperiment object is returned
}
\description{
Reads in inForm data in the form of cell coordinates, cell
  phenotypes (if available), and marker intensities and transforms to a
  SpatialExperiment object.  The assay stores the intensity level of
  every marker (rows) for every cell (columns). Cell phenotype, x and y
  coordinates and other cell properties are stored under colData. The cell
  properties to include are Cell.Area, Nucleus.Area, Nucleus.Compactness,
  Nucleus.Axis.Ratio, and Cell.Axis.Ratio.  Note that if the data does not
  include these parameters, we recommend adding it to the output from inForm
  with NAs in columns.
}
\examples{
raw_inform_data<-system.file("extdata","tiny_inform.txt.gz",package="SPIAT")
markers <- c("DAPI", "CD3", "PD-L1", "CD4", "CD8", "AMACR")
locations <- c("Nucleus", "Cytoplasm", "Membrane", "Cytoplasm", "Cytoplasm", 
"Cytoplasm")
formatted_inForm <- format_inform_to_spe(path=raw_inform_data, 
markers=markers, locations=locations)
}
