% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction_plot.R
\name{dimensionality_reduction_plot}
\alias{dimensionality_reduction_plot}
\title{Dimensionality reduction plot}
\usage{
dimensionality_reduction_plot(
  spe_object,
  plot_type = "UMAP",
  scale = TRUE,
  perplexity = 30,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{plot_type}{String. Choose from "UMAP" and "TSNE".}

\item{scale}{Boolean. Whether scale the marker intensities.}

\item{perplexity}{Numeric. Perplexity parameter of the Rtsne function (should
be positive and no bigger than 3 * perplexity < n - 1, where n is the
number of cells).}

\item{feature_colname}{String. Specify the column name to group the cells.}
}
\value{
A plot
}
\description{
Generates the dimensionality reduction plots (UMAP or tSNE)
  based on marker intensities. Cells are grouped by the categories under the
  selected column.
}
\examples{
dimensionality_reduction_plot(SPIAT::simulated_image, plot_type = "TSNE",
feature_colname = "Phenotype")
}
