% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_celltypes.R
\name{define_celltypes}
\alias{define_celltypes}
\title{define_celltypes}
\usage{
define_celltypes(
  spe_object,
  categories = NULL,
  category_colname = "Phenotype",
  names = NULL,
  new_colname = "Cell.Type",
  print_names = FALSE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{categories}{Vector. Names of the old cell types to be defined; if NULL,
the function will use predefined categories and names}

\item{category_colname}{(Phenotype) String specifying the name of the column
having the categories to be defined, by default "Phenotype".}

\item{names}{Vector of new names assigned to the selected categories; if
NULL, the function will use predefined categories and names. Should be of
the same length of `categories`.}

\item{new_colname}{(Optional) String specifying the name of the column to be
added, by default "Cell.Type".}

\item{print_names}{(Optional) Boolean if the user wants the original and new
names printed. Default is FALSE.}
}
\value{
An new SPE object is returned
}
\description{
Define new cell types based on the existing cell types
  (categories) under a selected column (e.g. base on marker combinations
  under "Phenotype" column). This function will create a new column to store
  the new cell types.
}
\details{
Users need to specify the names of the old cell categories and under
  which column the old cell categories exist. Then the users specify the
  names of the new cell types and the name of the new column to store the new
  cell types. Any cell categories that are not specified in `categories` arg
  but present in the image will be defined as "Undefined" in the new column.
}
\examples{
# the selected column is:
category_colname = "Phenotype"
# define the following marker combinations:
categories <- c("Tumour_marker", "Immune_marker1,Immune_marker2", 
"Immune_marker1,Immune_marker3",
"Immune_marker1,Immune_marker2,Immune_marker4", "OTHER")
# the new defined cell names:
names = c("Tumour", "Immune1", "Immune2","Immune3", "Others")
# the new names are stored under this column:
new_colname <- "Cell.Type"

defined_spe <- define_celltypes(SPIAT::simulated_image, 
categories = categories, category_colname = category_colname, names = names, 
new_colname = new_colname)
}
