% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_spatial_autocorrelation.R
\name{calculate_spatial_autocorrelation}
\alias{calculate_spatial_autocorrelation}
\title{calculate_spatial_autocorrelation}
\usage{
calculate_spatial_autocorrelation(raster_obj, metric = "globalmoran", d = NULL)
}
\arguments{
\item{raster_obj}{Raster object in the form of the output of
\code{\link{grid_metrics}}.}

\item{metric}{String. The method for calculating spatial autocorrelation.
Choose from "globalmoran" and "GearyC".}

\item{d}{Numeric. Upper bound local distance. The argument `d2` from function 
\link[elsa]{moran}. Default is NULL and the distance will be calculated 
automatically from the number of splits and the extent of the grid image.}
}
\value{
A number is returned
}
\description{
Takes the result of \code{\link{grid_metrics}} (a RasterLayer
  object) and calculate its spatial autocorrelation.
}
\examples{
grid <- grid_metrics(SPIAT::defined_image, FUN = calculate_entropy, 
n_split = 5, cell_types_of_interest=c("Tumour","Immune3"), 
feature_colname = "Cell.Type")
calculate_spatial_autocorrelation(grid, metric = "globalmoran")
}
