% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_proportions_of_cells_in_structure.R
\name{calculate_proportions_of_cells_in_structure}
\alias{calculate_proportions_of_cells_in_structure}
\title{calculate_proportions_of_cells_in_structure}
\usage{
calculate_proportions_of_cells_in_structure(
  spe_object,
  cell_types_of_interest,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{cell_types_of_interest}{String Vector of cell types to consider.}

\item{feature_colname}{String. The name of the column where the cell
types of interest are under.}
}
\value{
A data.frame
}
\description{
Calculate the proportion of cells of interest in each defined
  tissue structure relative to all cells in each structure and relative to
  the same cell type in the whole image.
}
\examples{
spe_border <- identify_bordering_cells(SPIAT::defined_image,
reference_cell = "Tumour", feature_colname = "Cell.Type", n_to_exclude = 10)
spe_dist <- calculate_distance_to_margin(spe_border)
spe_structure <- define_structure(spe_dist,
cell_types_of_interest = c("Immune1","Immune2","Immune3"),
feature_colname = "Cell.Type", n_margin_layers = 5)
calculate_proportions_of_cells_in_structure(spe_structure,
cell_types_of_interest = c("Immune1","Immune3"),feature_colname="Cell.Type")
}
