% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_cells_within_radius.R
\name{number_of_cells_within_radius}
\alias{number_of_cells_within_radius}
\title{Number of cells within a radius}
\usage{
number_of_cells_within_radius(
  spe_object,
  reference_celltype,
  target_celltype,
  radius = 20,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_celltype}{String. Cell type to be used for reference cells.}

\item{target_celltype}{String. Cell type to be used for target cells.}

\item{radius}{Numeric. Radius around the reference cells.}

\item{feature_colname}{String specifying the column with the desired cell
type annotations.}
}
\value{
A list of dataframes with the number of target cells of each of the
  reference cells
}
\description{
Calculates the number of cells of a target cell type
  within a pre-defined radius around cells of a reference cell type.
}
\examples{
n_in_radius <- number_of_cells_within_radius(SPIAT::defined_image,
reference_celltype = "Tumour", target_celltype="Immune1", radius = 50,
feature_colname = "Cell.Type")
}
