% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixing_score_summary.R
\name{mixing_score_summary}
\alias{mixing_score_summary}
\title{Calculate the (normalised) mixing score for interested cell types}
\usage{
mixing_score_summary(
  spe_object,
  reference_celltype,
  target_celltype,
  radius = 20,
  feature_colname
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_celltype}{String Vector. Cell types of the reference cells.}

\item{target_celltype}{String Vector. Cell types of the target cells.}

\item{radius}{The maximum radius around a reference cell type for another
cell to be considered an interaction.}

\item{feature_colname}{String specifying the column with the desired cell
type annotations.}
}
\value{
A data.frame of cell numbers, number of cell interactions,  mixing
  scores, and normalised mixing scores. If there are no reference or target
  cells found in the image, or there are no reference cells found within the
  specified radius of any reference cells,the returned (normalised) mixing
  scores will be NA. If there are no target cells found within the radius of
  any refernece cells, the returned (normalised) mixing scores will be 0.
}
\description{
Produces a data.frame with mixing scores of input reference and
  target cells from a SpatialExperiment object. It calculates
  reference-target interactions and reference-reference interactions based on
  a radius. It derives the mixing score and the normalised mixing score.
  Function returns NA if the mixing score is being calculated between cells
  of the same type.
}
\details{
The mixing score was originally defined as the number of
  immune-tumour interactions divided by the number of immune-immune
  interactions within a defined radius (Keren et al., 2018). The normalised
  mixing score normalises the immune-tumour interactions and immune-immune
  interactions within radius by the total number of immune-tumour and
  immune-immune interactions in the image, respectively. We have generalized
  this score to allow calculation of any two cell phenotypes defined by the
  user.
}
\examples{
mixing_score_summary(SPIAT::defined_image, reference_celltype = "Tumour", target_celltype="Immune1",
radius = 50, feature_colname = "Cell.Type")
}
