% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_marker_intensity_within_radius.R
\name{average_marker_intensity_within_radius}
\alias{average_marker_intensity_within_radius}
\title{average_marker_intensity_within_radius}
\usage{
average_marker_intensity_within_radius(
  spe_object,
  reference_marker,
  target_marker,
  radius = 20
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_marker}{String specifying the marker that is used for
reference cells.}

\item{target_marker}{String specifying the marker to calculate its average
intensity.}

\item{radius}{Numeric specifying the radius of search for cells around the
reference cells.}
}
\value{
A single number is returned
}
\description{
Calculates the average intensity of the target_marker within a
  radius from the cells positive for the reference marker. Note that it pools
  all cells with the target marker that are within the specific radius of any
  reference cell. Results represent the average intensities within a radius,
  but not a vector of metrics for each cell.
}
\examples{
average_marker_intensity_within_radius(SPIAT::simulated_image,
                                       reference_marker ="Immune_marker3",
                                       target_marker = "Immune_marker2",
                                       radius=30)
}
