% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC_of_cross_function.R
\name{AUC_of_cross_function}
\alias{AUC_of_cross_function}
\title{The difference in AUC of the cross function curves}
\usage{
AUC_of_cross_function(df.cross)
}
\arguments{
\item{df.cross}{Data.frame. The output of
\code{\link{calculate_cross_functions}}. Containing the positions of the
two curves. Columns contain "r", "border" and "theo".}
}
\value{
A number
}
\description{
Calculate the difference of area under the curve (AUC) between
  two curves, normalised by the total area of the graph.
}
\examples{
df_cross <- calculate_cross_functions(SPIAT::defined_image, method = "Kcross",
              cell_types_of_interest = c("Tumour","Immune3"),
              feature_colname ="Cell.Type", dist = 100)
AUC_of_cross_function(df_cross)
}
