% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomRegMethPredPlot.R
\name{binomRegMethPredPlot}
\alias{binomRegMethPredPlot}
\title{Plot the predicted methylation levels}
\usage{
binomRegMethPredPlot(
  pred,
  pred.type = "proportion",
  pred.col = "pred",
  group.col = NULL,
  title = "Predicted methylation levels",
  style = NULL,
  save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{pred}{\code{data.frame} used as an input
for the function \code{binomRegMethModelPred} (with columns 'Position',
covariate names matching the original output from the
function \code{binomRegMethModel}) with additional
columns containing the predictions generated by the function
\code{binomRegMethModelPred} and columns containing the name of each
experimental group. Rows without a valid group name
(empty character \code{""} or \code{NA}) are ignored}

\item{pred.type}{type of prediction returned by the function
\code{binomRegMethModelPred}: \code{proportion} or \code{link.scale}.
The default value is "proportion".}

\item{pred.col}{character defines the name of the column containing the
prediction values. The default value is "pred".}

\item{group.col}{character defines the name of the column containing the
experimental groups. If the group.col is set to NULL, the resulting plot
will be a simple scatter plot representing all predicted values disregarding
any experimental design. The default value is NULL.}

\item{title}{the text for the title}

\item{style}{named list containing the wanted style
(color and line type) for each experimental groups. The first
level list is named according each experimental group and for each
experimental group there is a list containing the \code{color} and the
\code{type} of the line. The line types should be among the following types:
\itemize{
\item \code{twodash},
\item \code{solid},
\item \code{longdash},
\item \code{dotted},
\item \code{dotdash},
\item \code{dashed},
\item \code{blank}.
}
The function accepts color name and its hexadecimal code.
The default value is NULL meaning that the colors will be chosen randomly and
the line style will be set to \code{solid}.}

\item{save}{file name to create on disk. When the value is set to NULL,
the plot is not saved. The default value is NULL.}

\item{verbose}{logical indicates if the algorithm should provide progress
report information. The default value is TRUE.}
}
\value{
This function prints out a plot of the predicted methylation levels
according to preset experimental groups.
}
\description{
This function accepts the \code{data.frame} used as an input
for the function \code{binomRegMethModelPred} with additional
columns containing the predictions generated by the function
\code{binomRegMethModelPred} and columns containing the name of each
experimental group and returns a plot representing the predicted methylation
levels according to each experimental group.
}
\examples{
#------------------------------------------------------------#
data(RAdat)
RAdat.f <- na.omit(RAdat[RAdat$Total_Counts != 0, ])
BEM.obj <- binomRegMethModel(
  data=RAdat.f, n.k=rep(5, 3), p0=0.003307034, p1=0.9,
  epsilon=10^(-6), epsilon.lambda=10^(-3), maxStep=200,
  Quasi = FALSE, RanEff = FALSE, verbose = FALSE
)
pos <- BEM.obj$uni.pos
newdata <- expand.grid(pos, c(0, 1), c(0, 1))
colnames(newdata) <- c("Position", "T_cell", "RA")
my.pred <- binomRegMethModelPred(BEM.obj, newdata, type = "link.scale", 
verbose = FALSE)
newdata$group <- ""
newdata[(newdata$RA == 0 & newdata$T_cell == 0),]$group <- "CTRL MONO"
newdata[(newdata$RA == 0 & newdata$T_cell == 1),]$group <- "CTRL TCELL"
newdata[(newdata$RA == 1 & newdata$T_cell == 0),]$group <- "RA MONO"
newdata[(newdata$RA == 1 & newdata$T_cell == 1),]$group <- "RA TCELL"
pred <- cbind(newdata, Pred = my.pred)
style <- list("CTRL MONO" = list(color = "blue", type = "dashed"),
"CTRL TCELL" = list(color = "green", type = "dashed"),
"RA MONO" = list(color = "blue", type = "solid"),
"RA TCELL" = list(color = "green", type = "solid"))
g <- binomRegMethPredPlot(pred, pred.col = "Pred", group.col = "group",
style = style, save = NULL, verbose = FALSE)

}
\author{
Audrey Lemaçon
}
