% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{renameDatasets}
\alias{renameDatasets}
\title{Rename datasets.}
\usage{
renameDatasets(SNPhood.o, newDatasetsMapping, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{newDatasetsMapping}{Named list.  Named list. For clarity of mapping, the names of the list must be the currently defined dataset names, 
and the values of each element the corresponding new ones.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
an object of class \code{\link{SNPhood}} with the requested datasets being renamed.
}
\description{
\code{renameDatasets} renames datasets from a \emph{SNPhood} object.
}
\examples{
data(SNPhood.o, package="SNPhood")
mapping = list("Individual1", "Individual2")
names(mapping) = annotationDatasets(SNPhood.o)
SNPhood_mod.o = renameDatasets(SNPhood.o, mapping)
}
\seealso{
\code{\link{renameBins}}, \code{\link{renameReadGroups}}, \code{\link{renameRegions}}
}

