% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plotAndClusterMatrix}
\alias{plotAndClusterMatrix}
\title{Clustering of read counts or enrichmens across bins for a specific dataset and read group}
\usage{
plotAndClusterMatrix(SNPhood.o, readGroup, dataset, nClustersVec = 3,
  normalize = TRUE, clustersToPlot = NULL, fileToPlot = NULL,
  verbose = FALSE, ...)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{readGroup}{Character(1). Default NULL. Read group that should be plotted, specified by its name as obtained by the function \code{annotationReadGroups}). If only one read group is defined in the object, this may also be NULL for user conveniance.}

\item{dataset}{Numeric(1) or Character(1). Single dataset that should be used for plotting, either specified as integer (such as 1, value must be
between 1 and the total number of datasets as defined in the object) or its annotation (name must appear in the dataset names as obtained via the function \code{annotationDatasets}).}

\item{nClustersVec}{Numeric. Default 2. The number of clusters the data should be divided into. This can either be a vector or a single value. if multiple clusters are specified, multiple clustering analyses will be performed and for each of them, a plot is produced. make sure to specify the parameter fileToPlot in that case; otherwise, only the last plot may be visible.}

\item{normalize}{Logical(1). Default TRUE. Should a normalization be done on the counts/enrichments values before clustering? If set to TRUE,
a normalization procedure based on subtracting the mean dividing by standard deviation for each region is performed. For more details, see the
vignette.}

\item{clustersToPlot}{Integer. Default NULL. Vector of clusters that should be plotted. If set to NULL, all clusters from the clustering result
will be plotted. Otherwise, only the clusters as specified by the user are plotted, omitting regions belonging to other clusters. This
is useful to, for example, only display regions that show a bin-dependent pattern and are not invariant across the whole user region.}

\item{fileToPlot}{Character(1) or \code{NULL}. Default \code{NULL}. 
Filename of the PDF file for the output plots.
If set to \code{NULL}, plots will be plotted to the currently active device.}

\item{verbose}{Logical(1). Default FALSE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}

\item{...}{Additional graphical parameters that can be used to modify the output of the function levelplot (panel.levelplot). 
See ?levelplot for details.}
}
\value{
The clustering reports the cluster in which each SNP falls, the average silhouette for pam clustering, plots for the clustered reads and a summary plot of average reads per cluster across the region being analyzed.
}
\description{
\code{plotAndClusterMatrix} can be used to cluster regions such as SNPs based on their local neighbourhood. 
The underlying clustering is done using partitioning around medoids (PAM). For more details, see the vignette.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood.o = plotAndClusterMatrix(SNPhood.o, readGroup = "paternal", dataset = 1, nClustersVec = c(3:6))
SNPhood.o = plotAndClusterMatrix(SNPhood.o, readGroup = "paternal", dataset = 1, normalize = FALSE)
}

