% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{associateGenotypes}
\alias{associateGenotypes}
\title{Associate genotypes with user regions from a \emph{SNPhood} object.}
\usage{
associateGenotypes(SNPhood.o, genotypeMapping, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{genotypeMapping}{Data frame. A data frame that establishes the mapping between datasets in the object and the corresponding genotype file and
column names. See the examples.
must be provided. See the Vignette for a more detailed description of the supported file format.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
Object of class \code{\linkS4class{SNPhood}} with the genotype information added to the slot \code{annotation}, element genotype.
You may retrieve it via the accessor function \code{\link{annotation}}.
}
\description{
The function \code{associateGenotypes} associates genotypes with SNP regions as defined in a \code{\linkS4class{SNPhood}} object. It is possible to assign
genotypes only for a subset of datasets as defined in a \code{\linkS4class{SNPhood}} object. 
To avoid any ambiguities, a 1:1 for genotype and dataset mapping must be given (ses below).
}
\examples{
data(SNPhood.o, package="SNPhood")
fileGenotypes = list.files(pattern = "*genotypes*",system.file("extdata", package = "SNPhoodData"), full.names = TRUE)
mapping = data.frame(samples = annotationDatasets(SNPhood.o), genotypeFile = rep(fileGenotypes, 2), sampleName = c("NA10847", "NA12890"))
SNPhood.o = associateGenotypes(SNPhood.o, mapping)
}

