% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{analyzeSNPhood}
\alias{analyzeSNPhood}
\title{Main function of \emph{SNPhood}}
\usage{
analyzeSNPhood(par.l, files.df, onlyPrepareForDatasetCorrelation = FALSE,
  verbose = TRUE)
}
\arguments{
\item{par.l}{Named list. Named list with all required parameter names and their respective values, which 
should be generated via the helper function \code{\link{getDefaultParameterList}}. 
Note that all supported parameters must be defined in the list, as obtained by the function \code{\link{getDefaultParameterList}} . 
See also ?getDefaultParameterList for details.}

\item{files.df}{Data frame with at least the column "signal" specifying the absolute paths to the BAM files that will be processed.
Optionally, further columns can be added. 
Supported are "input", "individual" and "genotype". See the Vignette for further details.
The data frame can either be created manually or via the helper function \code{\link{collectFiles}}.}

\item{onlyPrepareForDatasetCorrelation}{Logical(1). Default FALSE. If set to TRUE, only steps necessary to analyze
the correlation among datasets with respect to their read counts are calculated, which is less thsan time-consuming than running the full pipeline.
This is a quality control step to identify outlier datasets
that show artefacts and that should therefore be removed from the analysis. If set to FALSE (the default), the full pipeline is
executed. In both cases, the function \code{\link{plotAndCalculateCorrelationDatasets}} can be executed afterwards.}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
Object of class \code{\linkS4class{SNPhood}}. See the class description (?"SNPhood-class", or click the link) for details.
}
\description{
\code{analyzeSNPhood} is the main function of the \code{SNPhood} package.
All results, parameters and metadata are stored in an object of class \code{\linkS4class{SNPhood}}.
}
\details{
\strong{If you already have BAM files in objects of class \code{\linkS4class{BamFile}} or \code{\linkS4class{BamFileList}}, 
see the function \code{\link{collectFiles}} for how to seemlessly integrate them into the \code{SNPhood} framework.}

In addition, see the vignettes for more details.
}
\examples{
## For the following example, see also the workflow vignette!
library(SNPhoodData)
# get a list of files to process
dataDir = system.file("extdata", package = "SNPhoodData")
files.df = collectFiles(patternFiles = paste0(dataDir,"/*.bam"))
files.df$individual = c("GM10847", "GM10847", "GM12890", "GM12890")
fileUserRegions = list.files(pattern = "*.txt",dataDir, full.names = TRUE)
par.l = getDefaultParameterList(path_userRegions = fileUserRegions)
par.l$poolDatasets = TRUE
# Run the main function with the full pipeline
SNPhood.o = analyzeSNPhood (par.l, files.df)
}

