% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{findSGVariants}
\alias{findSGVariants}
\title{Identify splice variants from splice graph}
\usage{
findSGVariants(features, maxnvariant = 20, annotate_events = TRUE,
  include = c("default", "closed", "all"), cores = 1)
}
\arguments{
\item{features}{\code{SGFeatures} object}

\item{maxnvariant}{If more than \code{maxnvariant} variants are
identified in an event, the event is skipped, resulting in a warning.
Set to \code{NA} to include all events.}

\item{annotate_events}{Logical indicating whether identified
splice variants should be annotated in terms of canonical events.
For details see help page for \code{\link{annotateSGVariants}}.}

\item{include}{Character string indicating whether identified splice
variants should be filtered. Possible options are \dQuote{default}
(only include variants for events with all variants closed),
\dQuote{closed} (only include closed variants) and \dQuote{all}
(include all variants).}

\item{cores}{Number of cores available for parallel processing}
}
\value{
\code{SGVariants} object
}
\description{
Identify splice variants from splice graph.
}
\examples{
sgv <- findSGVariants(sgf_pred)
}
\author{
Leonard Goldstein
}
