% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaLogCPM}
\alias{setaLogCPM}
\title{log2(CPM) Transform
Computes the log2 counts-per-million (CPM) for each sample.
Samples are in rows and taxa in columns.}
\usage{
setaLogCPM(counts, pseudocount = 1, size_factors = NULL, scale_factor = 1e+06)
}
\arguments{
\item{counts}{A numeric matrix with rows as samples and columns as taxa.}

\item{pseudocount}{Numeric. Added to counts to avoid \code{log2(0)}. Default is 1.}

\item{size_factors}{Optional numeric vector of library sizes for each sample.
If \code{NULL}, the row sums are used.}

\item{scale_factor}{Numeric. The scaling factor, typically \code{1e6} for CPM.
Default is \code{1e6}.}
}
\value{
A list with:
\describe{
  \item{method}{The string \code{"logCPM"}.}
  \item{counts}{A matrix of the same dimensions with log2-transformed CPM values.}
}
}
\description{
log2(CPM) Transform
Computes the log2 counts-per-million (CPM) for each sample.
Samples are in rows and taxa in columns.
}
\details{
The transform is
\deqn{\log_2 \big( ((x + c)/L) \times s \big),}
where \eqn{c} is the pseudocount, \eqn{L} is the per-sample library size, and \eqn{s}
is \code{scale_factor}.
}
\examples{
mat <- matrix(c(10, 20, 100, 200), nrow = 2, byrow = TRUE)
out <- setaLogCPM(mat, pseudocount = 1)
out$counts
}
