% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{getLR}
\alias{Rnits.getLR}
\alias{getLR}
\alias{getLR,Rnits-method}
\alias{getLR,character,ANY-method}
\title{Get log-ratios}
\usage{
getLR(object, impute = FALSE)

\S4method{getLR}{Rnits}(object, impute = FALSE)
}
\arguments{
\item{object}{\code{\linkS4class{Rnits}} object}

\item{impute}{If \code{TRUE}, perform K-NN imputation to fill missing values}
}
\value{
A matrix of normalized log-ratios.
}
\description{
Extract normalized log-ratios from \code{\linkS4class{Rnits}} object
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
\dontrun{
# Fit model using gene-level summarization
rnitsobj <- fit(rnitsobj, gene.level = TRUE, clusterallsamples = FALSE)

# Get logratios
lr <- getLR(rnitsobj)
}
}

