% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{build.Rnits}
\alias{build.Rnits}
\title{Input the RGlist raw data, build a Rnits object and perform filtering and normalization}
\usage{
build.Rnits(obj, probedata = NULL, phenodata = NULL, filter = NULL,
  normalize = NULL, normmethod = NULL, plot = FALSE, center = FALSE,
  background = NULL, threshold = 0.8, logscale = FALSE)
}
\arguments{
\item{obj}{Raw expression data in \code{RGlist}, \code{AffyBatch} or simple data
frame format}

\item{probedata}{A data frame containing the probe names that should match the probe
names in raw data (optional)}

\item{phenodata}{A data frame with information about sample names. The rownames of
the data frame must match column names of the expression values. If input data is
data frame of log ratios, this is required.}

\item{filter}{An argument to perform background filtering of probes. If \code{NULL},
no filtering is done. If an integer (0-500), probes are flagged based on raw channel
intensity. If a vector of two numbers is provided, the first will be used for red channel
and the second for green channel. If \code{'background'}, probes whose intensities are
lower than 2 standard deviations less than the mean of the background intensity for
the channel are flagged.}

\item{normalize}{Character string specifying the normalization method for raw data.
If \code{Intensity}, the reference channels for all arrays are used to construct an
array-specific smoothing function which is then applied to normalize the sample channel.
If \code{Between}, the normalization method \code{normalizeBetweenArrays} in the
LIMMA package is used (use \code{normmethod} to further specify normalization
methods. See packaged LIMMA for details.). If \code{Within}, the normalization
method \code{normalizeWithinArrays} in the LIMMA package is used.}

\item{normmethod}{Normalization method for input data. Default \code{NULL}.
Can be one of 'quantile', 'vsn', 'Between'}

\item{background}{Only for AffyBatch data. If \code{TRUE}, background filtering
will be done on Affy data.}

\item{center}{If \code{TRUE}, the log-ratio data will be mean centered to
0 in the column space.}

\item{plot}{If \code{TRUE}, boxplots of normalized channel intensities and
log-ratios are drawn.}

\item{threshold}{Default \code{0.8}. Fraction of samples with missing data
for individual probes to be filtered out.}

\item{logscale}{Default \code{FALSE}. Is the data in logscale? If FALSE,
log2 transformation is done on the data.}
}
\value{
An object of S4 class \code{\linkS4class{Rnits}} (which is
derived from class \code{\linkS4class{exprSet}}), containing the probe data,
design data, expression data, phenotypical data (i.e. Time).
}
\description{
This function takes high-dimensional expression data as a RGList, creates a
\code{\linkS4class{Rnits}} object for subsequent filtering and normalization
}
\details{
See the Limma User's Guide for more details on \code{read.maimages}, \code{normalizeBetweenArrays},
\code{normalizeWithinArrays} and \code{RGList}. For importing microarray raw data,
use the 'Targets file' to specify experimental design. The target file has columns
SlideNumber, FileName, Cy3 (description of Cy3 channel ref/control/treatment), Cy5
(description of Cy3 channel ref/control/treatment) and Time. Time values should be
identical for control and treatment.
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')
}
\seealso{
\code{ExpressionSet}
}

