% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.R
\name{set.covariates.sva}
\alias{set.covariates.sva}
\title{set.covariates.sva}
\usage{
set.covariates.sva(rnb.set, sva.obj)
}
\arguments{
\item{rnb.set}{The \code{RnBSet} object to which the results should be added}

\item{sva.obj}{An object of class \code{SvaResult} as returned by \code{rnb.execute.sva}.}
}
\value{
The modified \code{RnBSet}. Note that the association information will not be stored.
}
\description{
Adds the results of Surrogate Variable Analysis (SVA) to an RnBSet
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
sva.obj <- rnb.execute.sva(rnb.set.example,c("Sample_Group","Treatment"),numSVmethod="be")
sva.obj$sva.performed
sva.obj$num.components
rnb.set.mod <- set.covariates.sva(rnb.set.example, sva.obj)
has.covariates.sva(rnb.set.example,"Sample_Group")
has.covariates.sva(rnb.set.mod,"Sample_Group")
}
}
\author{
Fabian Mueller
}
