% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rnb.write.table}
\alias{rnb.write.table}
\title{rnb.write.table}
\usage{
rnb.write.table(tt, fname, fpath = "", format = "csv", gz = FALSE, ...)
}
\arguments{
\item{tt}{Table to be written to file, usually in the form of a \code{matrix} or \code{data.frame}.}

\item{fname}{Target file name. If this file already exists, it will be overwritten.}

\item{fpath}{Target file path. If "" (default value), \code{fname} is assumed to contain the absolute path.}

\item{format}{Target format; one of \code{"csv"}, \code{"tab"} or \code{"txt"}, denoting comma-separated,
tab-separated and default text format, respectively. The last format allows for a user-specified
delimiter through an additional parameter \code{sep}. See the documentation of
\code{\link{write.table}} for more details.}

\item{gz}{Flag indicating whether the file should be zipped in \code{gz} format.}

\item{...}{Any additional arguments to be passed on to \code{write.table} or \code{utils::write.csv}.}
}
\value{
The (possibly updated) target file name, invisibly. If \code{gz} is \code{TRUE}, the string \code{".gz"} will
        be appended to \code{fname}.
}
\description{
Writes a table to a file. Different formats and compression options are available.
}
\examples{
\donttest{
data(mtcars)
rnb.write.table(mtcars,tempfile(pattern="cars",fileext=".csv"))
}
}
\seealso{
\code{\link{write.table}}
}
\author{
Fabian Mueller
}
