% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\name{rnb.sample.summary.table}
\alias{rnb.sample.summary.table}
\alias{rnb.sample.summary.table,RnBSet-method}
\title{rnb.sample.summary.table}
\usage{
rnb.sample.summary.table(rnbSet)
}
\arguments{
\item{rnbSet}{\code{\linkS4class{RnBSet}} of interest.}
}
\value{
a summary table (as data.frame) with the following variables for each sample (rows):
\item{sampleName}{Name of the sample}
\item{*_num (* can be 'sites' or a region type)}{Number of sites or regions with coverage in the sample}
\item{*_covgMean (\code{RnBiseqSet} only)}{Mean coverage of sites or regions in the sample}
\item{*_covgMedian (\code{RnBiseqSet} only)}{Median coverage of sites or regions in the sample}
\item{*_covgPerc25 (\code{RnBiseqSet} only)}{25 percentile of coverage of sites or regions in the sample}
\item{*_covgPerc75 (\code{RnBiseqSet} only)}{75 percentile of coverage of sites or regions in the sample}
\item{*_numCovg5,10,30,60 (\code{RnBiseqSet} only)}{Number of sites or regions with coverage greater or equal to 5,10,30,60}
\item{sites_numDPval5em2,1em2,1em3 (\code{RnBeadSet} only)}{Number of sites with a detection p-value smaller than 0.05,0.01,0.001}
\item{**_numSitesMean (** is any region type)}{Mean number of sites in a region}
\item{**_numSitesMedian}{Median number of sites in a region}
\item{**_numSites2,5,10,20}{Number of regions with at least 2,5,10,20 sites with valid methylation measurements}
}
\description{
Creates a sample summary table from an RnBSet object
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.sample.summary.table(rnb.set.example)
}
}
\author{
Fabian Mueller
}
