% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rnb.run.xml}
\alias{rnb.run.xml}
\title{rnb.run.xml}
\usage{
rnb.run.xml(fname, create.r.command = FALSE)
}
\arguments{
\item{fname}{XML configuration file to read.}

\item{create.r.command}{Flag indicating if the R command(s) that correspond to the given XML configuration should be
generated. If this is set to \code{TRUE}, a file named \code{"analysis.R"} is created in the
reports directory.}
}
\value{
Invisibly, the loaded, normalized and/or possibly filtered dataset as an object of type inheriting
        \code{\linkS4class{RnBSet}}.
}
\description{
Starts the analysis pipeline from an XML configuration file. This function uses the \pkg{XML} package to parse the
configuration file.
}
\details{
Two values are required to be specified (as tags) in the configuration file - \code{data.source} and
\code{dir.reports}. They define the input and output directory, respectively. In addition, the file may define
analysis option values. The vignette \emph{Comprehensive DNA Methylation Analysis with RnBeads} describes in details
the syntax of the XML configuration file.

The sample annotation table must be stored as a file in \code{data.source}. For more information about the required
parameters, see the documentation of \code{\link{rnb.run.analysis}}, which is called by this function.
}
\seealso{
\code{\link{rnb.run.analysis}} for starting an analysis pipeline
}
\author{
Yassen Assenov
}
