% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.sentrix.distributions}
\alias{rnb.plot.sentrix.distributions}
\title{rnb.plot.sentrix.distributions}
\usage{
rnb.plot.sentrix.distributions(rnb.set, fprefix = "sentrix_whisker", ...)
}
\arguments{
\item{rnb.set}{HumanMethylation450K dataset as an object of type \code{\linkS4class{RnBeadSet}}.}

\item{fprefix}{File name prefix to be used in the generated plots. In order to ensure independence of the operating
system, there are strong restrictions on the name of the file. See the documentation of
\code{\link{createReportPlot}} for more information.}

\item{...}{Other arguments passed to \code{\link{createReportPlot}}. These can include the named parameters
\code{report}, \code{width}, \code{height}, and others.}
}
\value{
Point-and-whisker plot (an instance of \code{\linkS4class{ReportPlot}}), or a list of such plots - one per
        slide. If the provided dataset does not contain valid Sentrix ID and position information (or is an empty
        dataset), this method returns \code{NULL}.
}
\description{
Creates one or more point-and-whisker plots showing beta value distributions at Sentrix positions.
}
\details{
If no additional parameters are specified, this function creates one PDF and one low-resolution PNG file for every
generated plot.
}
\seealso{
\code{\link{rnb.plot.sentrix.distribution}} for creating a single plot for a specified slide number
}
\author{
Yassen Assenov
}
