% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionProfiles.R
\name{rnb.plot.region.profile.density}
\alias{rnb.plot.region.profile.density}
\title{rnb.plot.region.profiles}
\usage{
rnb.plot.region.profile.density(
  rnb.set,
  sample,
  region.type = "",
  region.profile = NULL,
  extend.by = 0.33
)
}
\arguments{
\item{rnb.set}{RnBSet object}

\item{sample}{Index or name of the sample for which the plot should be generated}

\item{region.type}{Region type for which the plot should be generated}

\item{region.profile}{Alternative to specifying \code{region.type}, the function can accept a region profile
generated by the \code{rnb.find.relative.site.coord} function}

\item{extend.by}{A number between 0 and 1 specifying the percentage by which a region is
extended in order to capture methylation information before region start and after region end}
}
\value{
a ggplot2 object for plotting
        the plot shows the density of methylation levels of sites accross the specified region type for 
        all regions of that type from 0 (region start) to 1 (region end). Sites in the flanking areas are
        also shown (coordinates <0 and >1).
}
\description{
Plots the density of methylation levels accross all regions of the specified type
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.plot.region.profile.density(rnb.set.example,1,"genes")
}
}
\author{
Fabian Mueller
}
