% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionProfiles.R
\name{rnb.plot.locus.profile}
\alias{rnb.plot.locus.profile}
\title{rnb.plot.locus.profile}
\usage{
rnb.plot.locus.profile(
  rnbSet,
  chrom,
  start,
  end,
  grps = NULL,
  plot.m.regions = NULL,
  plot.m.heatmap = TRUE,
  plot.m.smooth = TRUE,
  cvals.grps = rnb.getOption("colors.category"),
  cvals.meth = rnb.getOption("colors.meth"),
  smooth.profile = "wide"
)
}
\arguments{
\item{rnbSet}{RnBSet object}

\item{chrom}{chromosome of window to plot}

\item{start}{start coordinate of window to plot}

\item{end}{end coordinate of window to plot}

\item{grps}{a list of indices for each group to be compared or NULL if no sample grouping information should be displayed}

\item{plot.m.regions}{character vector of region types whose methylation values should be displayed If \code{grps} is not \code{NULL}
the methylation values will be separated by sample groups.}

\item{plot.m.heatmap}{flag indicating whether sites methylation values should be displayed in a heatmap. If \code{grps} is not \code{NULL}
the heatmaps will be separated by sample groups.}

\item{plot.m.smooth}{flag indicating whether a scatterplot with smoothing curves should be displayed. If \code{grps} is not \code{NULL}
the colors will be used to separate sample groups.}

\item{cvals.grps}{colors to be used for the different groups}

\item{cvals.meth}{colors to be used for methylation values and heatmaps}

\item{smooth.profile}{profile to be used for the smoothing curves. Allowed values include 
\code{wide} (default) which yields smoother curvers and \code{narrow} which yields more "wiggly" curves}
}
\value{
a \code{ggplot2} plot object containing the plot
}
\description{
Computes methylation distributions for various region types and sample groups
}
\examples{
\donttest{
#see RnBeads vignette (section: 'Generating Locus Profile Plots') for examples
}
}
\author{
Fabian Mueller
}
