% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{rnb.plot.beta.comparison}
\alias{rnb.plot.beta.comparison}
\title{rnb.plot.beta.comparison}
\usage{
rnb.plot.beta.comparison(
  beta.values,
  fprefix,
  report = NULL,
  qq.length = 501L,
  points.per.group = rnb.getOption("distribution.subsample")
)
}
\arguments{
\item{beta.values}{Two beta value sequences in the form of a named \code{list} of two non-empty vectors of type
\code{double}. If any of the vectors contains \code{NA}s, this method may exit with an error.}

\item{fprefix}{File name prefix for the plots. This function appends the suffixes \code{"_density"},
\code{"_histogram"} and \code{"_qq"} to this prefix.}

\item{report}{Report to which the plots are to be added.}

\item{qq.length}{Positive \code{integer} value showing the number of quantiles to be calculated and presented
in the generated Q-Q plot.}

\item{points.per.group}{Maximum number of values to use in plotting a group's distribution. Groups that contain more
observations than this threshold are subsampled. Setting this parameter to a value less than
\code{2} disables subsampling.}
}
\value{
List of all generated plots, each being an object ot type \code{\linkS4class{ReportPlot}}.
}
\description{
Draws plots that compare two distributions of beta values.
}
\author{
Yassen Assenov
}
