% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.export.to.ewasher}
\alias{rnb.export.to.ewasher}
\title{rnb.export.to.ewasher}
\usage{
rnb.export.to.ewasher(rnb.set, out.dir, reg.type = "sites", ...)
}
\arguments{
\item{rnb.set}{Object of class \code{\linkS4class{RnBSet}}}

\item{out.dir}{output directory. If not existing, it will be created and all exported files will be placed here.
If existing, this functions results in an error.}

\item{reg.type}{region type to be exported}

\item{...}{passed on to \code{get.comparison.info}}
}
\value{
a list containing information on the export
}
\description{
Data exported to a format compatible with the FaST-LMM-EWASher tool for cell-mixture adjustment.
see \href{http://www.nature.com/nmeth/journal/v11/n3/full/nmeth.2815.html}{Zou, J., et al., Nature Methods, 2014}
for further details on the tool.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.export.to.ewasher(rnb.set.example,tempfile(pattern="forEwasher"))
}
}
\author{
Fabian Mueller
}
