% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.export.all.annotation}
\alias{rnb.export.all.annotation}
\title{rnb.export.all.annotation}
\usage{
rnb.export.all.annotation(
  out.dir,
  types = c("CpG", rnb.region.types(assembly)),
  assembly = "hg19",
  format = "bed"
)
}
\arguments{
\item{out.dir}{The directory to write the files to}

\item{types}{One-element \code{character} vector giving the name of the region annotation.}

\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}

\item{format}{output format. currently only \code{"bed"} is supported.}
}
\value{
\code{TRUE}, invisibly.
}
\description{
Wrapper for exporting all annotation sets
}
\examples{
\donttest{
logger.start(fname=NA)
rnb.export.all.annotation(tempdir(),c("genes","promoters"))
}
}
\author{
Fabian Mueller
}
