% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.execute.tnt}
\alias{rnb.execute.tnt}
\title{rnb.execute.tnt}
\usage{
rnb.execute.tnt(
  rnb.set,
  out.dir,
  exp.bed = rnb.getOption("export.to.bed"),
  exp.trackhub = rnb.getOption("export.to.trackhub"),
  region.types = rnb.getOption("export.types"),
  ...
)
}
\arguments{
\item{rnb.set}{\code{\linkS4class{RnBSet}} object}

\item{out.dir}{output directory.}

\item{exp.bed}{A character vector indicating which data types should be exported to UCSC. Possible values in the vector are \code{bigBed} and \code{bigWig}.
If \code{NULL}, UCSC export is disabled}

\item{exp.trackhub}{file types which should be exported to a trackhub structure.}

\item{region.types}{a character vector indicating region types to be exported}

\item{...}{Arguments passed to \code{\link{rnb.export.to.trackhub}}}
}
\value{
a list containing information on the export
}
\description{
export RnBSet to various output data formats
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.execute.tnt(rnb.set.example,tempdir())
}
}
\author{
Fabian Mueller
}
