% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex.R
\name{rnb.execute.sex.prediction}
\alias{rnb.execute.sex.prediction}
\title{rnb.execute.sex.prediction}
\usage{
rnb.execute.sex.prediction(rnb.set)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type \code{\linkS4class{RnBeadRawSet}}.}
}
\value{
The possibly modified dataset. If sex could be predicted, the sample annotation table is enriched with
two more columns - \code{"Predicted Male Probability"} and \code{"Predicted Sex"}.
}
\description{
Infers the sex of every sample in the given dataset, based on average signal intensity values on
the autosomes and the sex chromosomes.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.example <- rnb.execute.sex.prediction(rnb.set.example)
table(rnb.set.example[, "Predicted Sex"])
}
}
\author{
Yassen Assenov
}
