% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{rnb.execute.imputation}
\alias{rnb.execute.imputation}
\title{rnb.execute.imputation}
\usage{
rnb.execute.imputation(
  rnb.set,
  method = rnb.getOption("imputation.method"),
  update.ff = TRUE,
  ...
)
}
\arguments{
\item{rnb.set}{Dataset object inheriting from \code{\linkS4class{RnBSet}}.}

\item{method}{Imputation method to be used, must be one of \code{"mean.cpgs"}, \code{"mean.samples"},
\code{"random"}, \code{"knn"}, \code{"median.cpgs"}, \code{"median.samples"}, or \code{"none"}.}

\item{update.ff}{flag indicating if the disk based matrices should be updated. Should be set to FALSE, if methylation
matrix should only temporarly be changed. If this value is FALSE, the region level methylation values
are not updated and only the site-wise matrix is changed temporarly.}

\item{...}{Optional arguments passed to knn.imputation}
}
\value{
The modified rnb.set object without missing methylation values.
}
\description{
Removes missing methylation values in the methylation matrix of the given object
}
\details{
Imputes missing values by applying on the following methods:
         \describe{
           \item{mean.cpgs:}{missing values are inferred as the average methylation value from all other 
           (non-mising) CpGs in this sample}
           \item{mean.samples:}{missing values are inferred as the average methylation value from all other 
           (non-mising) values at this CpG sites in all other samples}
           \item{random:}{missing values are inferred by randomly selecting a (non-missing) methylation value
           from any other sample at this CpG site}
           \item{knn:}{missing values are inferred by k-nearest neighbors imputation (see \pkg{impute})}
           \item{median.cpgs:}{missing values are inferred as the median methylation value from all other 
           (non-mising) CpGs in this sample}
           \item{median.samples:}{missing values are inferred as the median methylation value from all other 
           (non-mising) values at this CpG sites in all other samples}
           \item{none:}{imputation should not be performed}
         }
}
\author{
Michael Scherer
}
