% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedycut.R
\name{rnb.execute.greedycut}
\alias{rnb.execute.greedycut}
\title{rnb.execute.greedycut}
\usage{
rnb.execute.greedycut(
  rnb.set,
  pval.threshold = rnb.getOption("filtering.greedycut.pvalue.threshold"),
  min.coverage = rnb.getOption("filtering.coverage.threshold"),
  rc.ties = rnb.getOption("filtering.greedycut.rc.ties")
)
}
\arguments{
\item{rnb.set}{HumanMethylation450K dataset as an object of type \code{\linkS4class{RnBeadSet}}.}

\item{pval.threshold}{The P-value threshold. For further information, see the option \code{"filtering.greedycut.pvalue.threshold"}
in \code{\link{rnb.options}}.}

\item{min.coverage}{The coverage threshold. For further information, see the option \code{"filtering.coverage.threshold"}
in \code{\link{rnb.options}}.}

\item{rc.ties}{Flag indicating what the behaviour of the algorithm should be in case of ties between values of rows
(probes) and columns (samples). See the corresponding parameter in
\code{\link{greedycut.filter.matrix}} for more details.}
}
\value{
\code{NULL} if \code{rnb.set} does not contain a matrix of detection p-values, or if all p-values denote
        reliable measurements. Otherwise, a list of the following elements:
        \describe{
          \item{"infos"}{Table summarizing the iterations of the algorithm, as returned by
               \code{\link{greedycut.filter.matrix}}.}
          \item{"statistics"}{Additional statistics on all iterations, as returned by
               \code{\link{greedycut.get.statistics}}.}
          \item{"iteration"}{Number of Greedycut iterations + \code{1} applied to the dataset, that is,
               a value of 1 indicates that the dataset was not modified.}
          \item{"sites"}{Indices of all sites to be removed.}
          \item{"samples"}{Indices of all samples to be removed.}
        }
}
\description{
Executes the Greedycut procedure for probe and sample filtering based on the detection p-values, and calculates
statistics on its iterations.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
greedy.result <- rnb.execute.greedycut(rnb.set.example)
# Number of applied iterations
greedy.result$iteration
}
}
\author{
Yassen Assenov
}
