% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{rnb.execute.batcheffects}
\alias{rnb.execute.batcheffects}
\title{rnb.execute.batcheffects}
\usage{
rnb.execute.batcheffects(rnb.set, pcoordinates = NULL)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{pcoordinates}{Coordinates of the samples of \code{rnb.set} in the principal components space, as returned by
\code{\link{rnb.execute.dreduction}}.}
}
\value{
Results of attempted tests for associations in the form of a list with up to three elements:
        \describe{
          \item{\code{"permutations"}}{\code{integer} matrix of index permutations. The number of rows in the matrix
               is \emph{N} - the number of samples in \code{rnb.set}. Every column in this matrix denotes a sample
               permutation; the first column is the sequence 1 to \emph{N}. This element is included only when
               \code{rnb.getOption("exploratory.correlation.permutations")} is non-zero and there are numeric traits
               to be tested.}
          \item{\code{"pc"}}{List of four matrices named \code{"failures"}, \code{"tests"}, \code{"correlations"}
               and \code{"pvalues"}. The rows in each of these matrices correspond to the first several principal
               components, and the columns - to selected traits. This element is not included in the returned list
               when \code{pcoordinates} is \code{NULL}.}
          \item{\code{"traits"}}{List of four square symmetric matrices named \code{"failures"}, \code{"tests"},
               \code{"correlations"} and \code{"pvalues"}, containing information about the performed tests for
               pairwise trait association. This element is included only if two or more traits were tested.}
        }
}
\description{
Performs tests for association between traits and principal components.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
regs <- c("sites", summarized.regions(rnb.set.example))
dreduction <- function(x) rnb.execute.dreduction(rnb.set.example, x)
pcoordinates <- lapply(regs, dreduction)
names(pcoordinates) <- regs
result <- rnb.execute.batcheffects(rnb.set.example, pcoordinates)
}
}
\seealso{
\code{\link{rnb.run.exploratory}} for running the whole exploratory analysis module
}
\author{
Yassen Assenov
}
