% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R, R/RnBeadSet-class.R,
%   R/RnBeadRawSet-class.R
\docType{methods}
\name{remove.sites,RnBSet-method}
\alias{remove.sites,RnBSet-method}
\alias{remove.sites}
\alias{remove.sites,RnBeadSet-method}
\alias{remove.sites,RnBeadRawSet-method}
\title{remove.sites-methods}
\usage{
\S4method{remove.sites}{RnBSet}(object, probelist, verbose = FALSE)

\S4method{remove.sites}{RnBeadSet}(object, probelist, verbose = TRUE)

\S4method{remove.sites}{RnBeadRawSet}(object, probelist, verbose = TRUE)
}
\arguments{
\item{object}{Dataset of interest.}

\item{probelist}{List of probes to be removed in the form of a \code{logical}, \code{integer} or \code{character}
vector. If this parameter is \code{logical}, it is not recycled; its length must be equal to the
number of probes in \code{object}. If it is \code{integer} or \code{character}, it must list only
probes that exist in the dataset. Specifying probe indices larger than the number of probes, or
non-existent probe identifiers results in an error.}

\item{verbose}{if \code{TRUE} additional diagnostic output is generated}
}
\value{
The modified dataset.
}
\description{
Removes the specified probes from the dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
print(rnb.set.example)
## remove 100 random sites
s2r<-sample.int(nrow(sites(rnb.set.example)), 100)
rnb.set.f<-remove.sites(rnb.set.example, s2r)
print(rnb.set.f)
}
}
\seealso{
\code{\link[=remove.samples,RnBSet-method]{remove.samples}} for removing samples from a methylation dataset
}
