% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{methods}
\name{reload,RnBDiffMeth-method}
\alias{reload,RnBDiffMeth-method}
\alias{reload}
\title{reload-methods}
\usage{
\S4method{reload}{RnBDiffMeth}(
  object,
  save.file,
  disk.path = tempfile(pattern = "diffmeth_", tmpdir = getOption("fftempdir"))
)
}
\arguments{
\item{object}{\code{\linkS4class{RnBDiffMeth}} object}

\item{save.file}{location of the ff data saved to disk (i.e. save in save.RData and save.ffData)}

\item{disk.path}{path on the disk for DMTs. can be new or be the same as in the original object}
}
\value{
the updated RnBDiffMeth object
}
\description{
reload disk dumped tables. Useful if the table files are manually copied or if the object is loaded again.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
#compute differential methylation
pcols <- c("Sample_Group","Treatment")
tdir <- tempfile(pattern="working")
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pcols,disk.dump=TRUE,disk.dump.dir=tdir)
#get temporary file names
fn.save.tabs <- tempfile(pattern="saveTables")
fn.save.obj  <- tempfile(pattern="saveObject")
#save the object and the tables to disk
save(dm,file=fn.save.obj)
save.tables(dm,fn.save.tabs)
#delete the object from the workspace
destroy(dm)
rm(dm)
#reload the object and tables
load(fn.save.obj)
dm.new <- reload(dm,fn.save.tabs)
}
}
\author{
Fabian Mueller
}
