% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{regions,RnBSet-method}
\alias{regions,RnBSet-method}
\alias{regions}
\title{regions-methods}
\usage{
\S4method{regions}{RnBSet}(object, type = NULL)
}
\arguments{
\item{object}{Dataset of interest.}

\item{type}{Region type(s) of interest as a \code{character} vector. If this is set to \code{NULL}, all region
types summarized in the object are returned.}
}
\value{
Methylation site and region assignment. If \code{type} is singleton, a \code{matrix} is returned. The first
		   column corresponds to the methylation context index. The second column is the index of the chromosome in
        the genome, and the third is the index of the region in the \code{GRanges} object of the region type
        annotation. When \code{length(type)>1}, a list of such matrices is returned for each element of \code{type}.
		   If \code{type} is \code{NULL}, matrices for all summarized region types are returned.
}
\description{
Methylation regions, information for which is present in the \code{RnBSet} object.
}
\note{
Methylation context index is an integer number denoting the sequence context of the cytosine of interest. Index
\code{1} corresponds to \code{CpG}, the only supported index in bisulfite sequencing datasets.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
head(regions(rnb.set.example))
}
}
\seealso{
\code{\link[=summarized.regions,RnBSet-method]{summarized.regions}} for all summarized region types in a dataset;
  \code{\link{rnb.get.chromosomes}} listing all supported chromosomes for a given genome assembly
}
\author{
Pavlo Lutsik
}
