% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{read.bed.files}
\alias{read.bed.files}
\title{read.bed.files}
\usage{
read.bed.files(
  base.dir = NULL,
  file.names = NULL,
  sample.sheet = NULL,
  file.names.col = 0,
  assembly = rnb.getOption("assembly"),
  region.types = rnb.region.types.for.analysis(assembly),
  pos.coord.shift = 1L,
  skip.lines = 1,
  sep.samples = rnb.getOption("import.table.separator"),
  merge.bed.files = TRUE,
  useff = rnb.getOption("disk.dump.big.matrices"),
  usebigff = rnb.getOption("disk.dump.bigff"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{base.dir}{Directory with BED files contatining processed methylation data}

\item{file.names}{Optional non-empty \code{character} vector listing the names of the files that should be
loaded relative to \code{base.dir}. If supplied, this vector must not contain \code{NA}
   among its elements.}

\item{sample.sheet}{Optional file name containing a table of sample annotation data, or the table itself in the form
of a \code{\link{data.frame}} or \code{matrix}. Only (and all) samples defined in this table
will be loaded. The table is expected to contain a column named \code{"barcode"} that lists the
samples' Sentrix  barcodes. If such a column is not present, this function searches for columns
\code{"Sentrix_ID"} and \code{"Sentrix_Position"} (or similar) that build a barcode.}

\item{file.names.col}{Column of the sample sheet which contains the file names (integer singleton). If \code{NA}
an attempt will be made to find a suiting column automatically.}

\item{assembly}{Genome assembly. Defaults to human (\code{"hg19"})}

\item{region.types}{\code{character} vector storing the types of regions for which the methylation information is to
be summarized. The function \code{\link{rnb.region.types}} provides the list of all supported
regions. Setting this to \code{NULL} or an empty vector restricts the dataset to site
methylation only.}

\item{pos.coord.shift}{The frame shift between the the CpG annotation (1-based) and the coordinates in the loaded BEDs.
If BEDs have 0-based coordinates, \code{pos.coord.shift=1} (default).}

\item{skip.lines}{The number of top lines to skip while reading the BED files}

\item{sep.samples}{\code{character} singleton used as field separator in the sample sheet file.
Default value is taken by the call to \code{rnb.getOption("import.table.separator")}}

\item{merge.bed.files}{In case multiple BED files are specified for each sample, the flag indicates whether the
methylation calls should be merged after reading}

\item{useff}{If \code{TRUE}, functionality provided by the \code{ff} package will be used to read the data efficiently.}

\item{usebigff}{flag specifying whether the extended ff functionality should be used (large matrix support for ff)}

\item{verbose}{Flag indicating ifthe messages to the logger should be sent. Note that the logger
must be initialized prior to calling this function. Logging is useful for keeping a
record of the downloaded and processed samples. Also, informative messages are
stored in case of an error.}

\item{...}{Further arguments which are passed to the internal function \code{read.single.bed} and to \code{read.table}}
}
\value{
an object of class \code{\linkS4class{RnBiseqSet}}
}
\description{
Reads a reduced-representation/whole-genome bisulfite sequencing data set from a set of BED files
}
\details{
To control the BED column assignment, one should also supply arguments to \code{read.single.bed}.
}
\author{
Pavlo Lutsik
}
