% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{performGOEnrichment.diffVar}
\alias{performGOEnrichment.diffVar}
\title{performGOEnrichment.diffVar}
\usage{
performGOEnrichment.diffVar(
  rnbSet,
  diffmeth,
  enrich.diffMeth = NULL,
  ontologies = c("BP", "MF"),
  rank.cuts.region = c(100, 500, 1000),
  add.auto.rank.cut = TRUE,
  rerank = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{rnbSet}{RnBSet object for which dirrential variability was computed}

\item{diffmeth}{RnBDiffMeth object. See \code{\link{RnBDiffMeth-class}} for details.}

\item{enrich.diffMeth}{Result of \code{performGOEnrichment.diffMeth}. NULL, if enrichment should only be performed for differential variability.}

\item{ontologies}{GO ontologies to use for enrichment analysis}

\item{rank.cuts.region}{Cutoffs for combined ranking that are used to determine differentially variable regions}

\item{add.auto.rank.cut}{flag indicating whether an automatically computed cut-off should also be considered.}

\item{rerank}{For deterimining differential variability: should the ranks be ranked again or should the absolute ranks be used.}

\item{verbose}{Enable for detailed status report}

\item{...}{arguments passed on to the parameters of \code{GOHyperGParams} from the \code{GOstats} package}
}
\value{
a DiffMeth.enrich object (S3) containing the following attributes
\item{region}{Enrichment information for differential variability on the region level. See \code{GOHyperGresult} from the \code{GOstats} package for furthert details}
}
\description{
performs Geno Ontology (GO) enrichment analysis for a given differential variability table.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.diffVar(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
res <- performEnrichment.diffVar(rnb.set.example,dm)
}
}
\author{
Fabian Mueller and Michael Scherer
}
