% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger.status}
\alias{logger.status}
\alias{logger.info}
\alias{logger.warning}
\alias{logger.error}
\title{Writing text messages to the log file.}
\usage{
logger.status(txt)

logger.info(txt)

logger.warning(txt)

logger.error(txt, terminate = rnb.getOption("logging.exit.on.error"))
}
\arguments{
\item{txt}{Text to add to the log file. This must be a \code{character} vector; its elements are concatenated
using a single space (\code{" "}) as a separator.}

\item{terminate}{Flag indicating if the execution is to be terminated after this error message is added to the log.}
}
\value{
None (invisible \code{NULL}).
}
\description{
Appends a single-line status message to the log text file. The message is prepended by its type, which is one of
\code{STATUS}, \code{INFO}, \code{WARNING} or \code{ERROR}.
}
\examples{
\donttest{
if (!logger.isinitialized())
  logger.start(fname = NA)
logger.status(c("Reached step", 2))
logger.info(c("Provided email:", rnb.getOption("email")))
}
}
\seealso{
\code{\link{logger.isinitialized}}to check if logging is activated;
  \code{\link{logger.start}} for initializing a logger or starting a section
}
\author{
Yassen Assenov
}
