% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger.validate.file}
\alias{logger.validate.file}
\title{logger.validate.file}
\usage{
logger.validate.file(file, is.file = TRUE, terminate = TRUE)
}
\arguments{
\item{file}{Name of file or directory to validate.}

\item{is.file}{Flag indicating if the given name must denote an existing file. If this is \code{FALSE}, the given
name must denote a directory. Set this to \code{NA} if both types are an acceptable scenario.}

\item{terminate}{Flag indicating if the execution is to be terminated in case the validation fails. This parameter
determines if an error message (\code{terminate} is \code{TRUE}) or a warning message
(\code{terminate} is \code{FALSE}) is to be sent to the log when the specified file or directory
does not exist, is not of the accepted type or is not accessible.}
}
\value{
Whether the validation succeeded or not, invisibly. Note that when \code{terminate} is \code{TRUE} and the
        validation fails, the R session is closed and thus no value is returned.
}
\description{
Validates the specified file or directory exists. Prints an error or a warning message to the log if it does not
exist, it is not of the accepted type or is not accessible.
}
\examples{
\donttest{
if (!logger.isinitialized())
  logger.start(fname = NA)
# Validate the current working directory exists
logger.validate.file(getwd(), FALSE)
}
}
\author{
Yassen Assenov
}
