% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger.getfiles}
\alias{logger.getfiles}
\title{logger.getfiles}
\usage{
logger.getfiles()
}
\value{
Vector storing the full names of the files that are being used by the logger. This vector contains \code{NA}
        as an element if the logger is (also) using the console for its output. If logging functionality is disabled
        (see \code{\link{rnb.options}}) or the logger is not initialized, this function returns \code{NULL}.
}
\description{
Gets the files currently used by the logger.
}
\examples{
\donttest{
if (NA \%in\% logger.getfiles())
  cat("Console logger is enabled\n")
}
}
\seealso{
\code{\link{logger.isinitialized}} to check if logging is activated;
  \code{\link{logger.start}} for initializing a logger or starting a section
}
\author{
Yassen Assenov
}
