% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.R
\name{has.covariates.sva}
\alias{has.covariates.sva}
\title{has.covariates.sva}
\usage{
has.covariates.sva(rnb.set, target)
}
\arguments{
\item{rnb.set}{\code{RnBSet} object}

\item{target}{target variable. Must be in \code{pheno(rnb.set)} and belong to target variables for which the
SVs have already been computed and stored in the RnBSet.}
}
\value{
\code{logical(1)}
}
\description{
Returns whether Surrogate Variables have been computed and added to the \code{rnb.set} for a given target variable
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
sva.obj <- rnb.execute.sva(rnb.set.example,c("Sample_Group","Treatment"),numSVmethod="be")
sva.obj$sva.performed
sva.obj$num.components
rnb.set.mod <- set.covariates.sva(rnb.set.example, sva.obj)
has.covariates.sva(rnb.set.example,"Sample_Group")
has.covariates.sva(rnb.set.mod,"Sample_Group")
has.covariates.sva(rnb.set.mod,"Treatment")
}
}
\author{
Fabian Mueller
}
