% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{deviation.plot.beta}
\alias{deviation.plot.beta}
\title{deviation.plot.beta}
\usage{
deviation.plot.beta(betas, c.values = NULL, c.legend = NULL)
}
\arguments{
\item{betas}{Non-empty numeric \code{matrix} of methylation beta values. Rows in this matrix must denote sites or
regions, and columns - samples. If a locus (row in the matrix) contains missing values only, it is
not included in the plot.}

\item{c.values}{Vector (usually a \code{factor}) storing category or quantitative values for each site or region. The
length of this vector must be equal to \code{nrow(betas)}, the \emph{i}-th element storing the
property values for the \emph{i}-th locus in \code{betas}. Note that this vector's names, if present,
are ignored.}

\item{c.legend}{If \code{c.values} stores categories, this parameter specifies the mapping from property values to
colors. The mapping is in the form of a named \code{character} vector. All values that appear in
\code{c.values} must be present among the names of this vector. The order of the values in this
mapping determines in which order the colors are stacked (when the number of loci is large). If
\code{c.values} denotes a quantitative measure, this parameter is a singleton \code{integer},
specifying the color scheme for visualizing the values. Currently, the only supported values are
\code{2} and \code{3}. See \code{\link{rnb.options}} for more details.}
}
\value{
Methylation variability as a number between \code{0} and \code{1}, invisibly. This number denotes the relative
        area of variation in the generated plot.
}
\description{
Creates a deviation plot based on the methylation beta values of a population.
}
\author{
Yassen Assenov
}
