% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{create.scatter.dens.points}
\alias{create.scatter.dens.points}
\title{create.scatter.dens.points}
\usage{
create.scatter.dens.points(
  df2p,
  is.special = NULL,
  dens.special = TRUE,
  mock = FALSE
)
}
\arguments{
\item{df2p}{\code{data.frame} to be plotted. Only the fist two columns are taken into account as
x and y coordinates respectively}

\item{is.special}{boolean vector of length equal to the number of rows in \code{df2p}. Specifies
which points should be highlighed seperately in a different color}

\item{dens.special}{Flag indicating whether the points of the special population should be colored
according to their density}

\item{mock}{Should only the axis be plotted? useful when exporting scatterplots with lots of points
as immage and the corresponding axis as vector graphics.}
}
\value{
\code{ggplot} object
}
\description{
Creates a scatterplot containing all points in a given data.frame. Points are colored according to point
density. Optionally, a selection of points are shown in a different color
}
\examples{
\donttest{
d <- data.frame(x=rnorm(1000),y=rnorm(1000))
s <- rep(FALSE,1000)
s[sample(1:length(s),100)] <- TRUE
create.scatter.dens.points(d,s)
}
}
\author{
Fabian Mueller
}
