% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{methods}
\name{addDiffMethTable,RnBDiffMeth-method}
\alias{addDiffMethTable,RnBDiffMeth-method}
\alias{addDiffMethTable}
\title{addDiffMethTable-methods}
\usage{
\S4method{addDiffMethTable}{RnBDiffMeth}(
  object,
  dmt,
  comparison,
  region.type,
  grp.labs = c("group1", "group2")
)
}
\arguments{
\item{object}{\code{\linkS4class{RnBDiffMeth}} object}

\item{dmt}{Differential methylation table to add}

\item{comparison}{character or index of the comparison of the table to retrieve}

\item{region.type}{character or index of the region type of the table to retrieve}

\item{grp.labs}{character vector of length 2 specifying the names of the groups being compared}
}
\value{
the updated RnBDiffMeth object
}
\description{
Adds a differential methylation table
}
\note{
Caveat: if disk dumping is enabled the resulting object tables will be stored in the initial location of the object.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.computeDiffMeth(rnb.set.example,"Sample_Group",c("genes","tiling"))
s.groups <- rnb.sample.groups(rnb.set.example,"Sample_Group")[[1]]
dmt.sites <- computeDiffTab.extended.site(meth(rnb.set.example),s.groups[[1]],s.groups[[2]])
map.regions.to.sites <- regionMapping(rnb.set.example,"promoters")
dmt.promoters <- computeDiffTab.default.region(dmt.sites,map.regions.to.sites)
cmp.name <- get.comparisons(dm)[1]
grp.labs <- get.comparison.grouplabels(dm)[1,]
#add the promoter level differential methylation table
dm.add <- addDiffMethTable(dm,dmt.promoters,cmp.name,"promoters",grp.labs)
get.region.types(dm.add)
}
}
\author{
Fabian Mueller
}
