% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{class}
\name{RnBSet-class}
\alias{RnBSet-class}
\title{RnBSet Class}
\description{
Basic class for storing DNA methylation and experimental quality information
}
\details{
It is a virtual class and objects of type \code{RnBSet} should not be instantiated. Instead, the child classes are
used: \code{\linkS4class{RnBeadRawSet}} and \code{\linkS4class{RnBeadSet}} for Infinium HumanMethylation and
\code{\linkS4class{RnBiseqSet}} for bisulfite sequencing data
}
\section{Slots}{

\describe{
  \item{\code{pheno}}{Sample annotations (phenotypic and processing data) in the form of a \code{data.frame}.}
  \item{\code{sites}}{A \code{matrix} object storing the identifiers of the methylation sites for which the
		methylation information is present}
  \item{\code{meth.sites}}{\code{matrix} of methylation values. Every row corresponds to a methylation site,
		and every column - to a sample.}
  \item{\code{covg.sites}}{\code{matrix} of coverage values. Every row corresponds to a methylation site,
		and every column - to a sample.}
  \item{\code{regions}}{\code{list} of all identifiers of methylation sites for which methylation information
		is available.}
  \item{\code{meth.regions}}{\code{list} of methylation \code{matrix} objects, one per available region type. Every row in a
		matrix corresponds to a methylation site, and every column - to a sample.}
  \item{\code{covg.regions}}{\code{list} of coverage \code{matrix} objects, one per available region type.
		Every row corresponds to a region, and every column - to a sample.}
	 \item{\code{status}}{\code{list} with meta-information about the object.}
	 \item{\code{assembly}}{\code{character} vector of length one, specifying the genome assembly which the object is linked to, e.g. "hg19".}
  \item{\code{target}}{\code{character} vector of length one, specifying the feature class:
		\code{"CpG"} for sequencing data, \code{"probes450"} and \code{"probes27"} for
		HumanMethylation450 and HumanMethylation27 microarrays respectively.}
  \item{\code{inferred.covariates}}{\code{list} with covariate information.
		Can contain elements \code{"sva"} and \code{"cell.types"}.}
	 \item{\code{version}}{Package version in which the dataset was created.}
	 \item{\code{imputed}}{Flag indicating if methylation matrix has been imputed.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{\link[=pheno,RnBSet-method]{pheno}}}{Gets the phenotypic and processing data of the dataset.}
  \item{\code{\link[=samples,RnBSet-method]{samples}}}{Gets the identifiers of all samples in the dataset.}
  \item{\code{\link[=summarized.regions,RnBSet-method]{summarized.regions}}}{Gets the genomic annotations for
  which methylation data is present.}
	 \item{\code{\link[=meth,RnBSet-method]{meth}}}{Gets a \code{matrix} of methylation values in the dataset.}
	 \item{\code{\link[=mval,RnBSet-method]{mval}}}{Gets a \code{matrix} of M values in the dataset.}
  \item{\code{\link[=covg,RnBSet-method]{covg}}}{Gets the \code{matrix} of coverage values of the dataset.}
  \item{\code{\link[=remove.sites,RnBSet-method]{remove.sites}}}{Removes sites from the dataset.}
  \item{\code{\link[=remove.samples,RnBSet-method]{remove.samples}}}{Removes samples from the dataset.}
  \item{\code{\link[=addPheno,RnBSet-method]{addPheno,RnBSet-method}}}{Add sample annotation to the dataset.}
  \item{\code{\link[BiocGenerics]{combine}}}{Combines two datasets.}
  \item{\code{\link{regionMapping,RnBSet-method}}}{Retrieve the sites mapping to a given region type}
  \item{\code{\link[=rnb.sample.summary.table,RnBSet-method]{rnb.sample.summary.table}}}{Creates a sample summary table from an RnBSet object.}
  \item{\code{\link{isImputed,RnBSet-method}}}{Getter for the imputation slot.}
}
}

\author{
Pavlo Lutsik
}
