% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmiq.R
\name{BMIQ}
\alias{BMIQ}
\title{BMIQ}
\usage{
BMIQ(
  beta.v,
  design.v,
  doH = TRUE,
  nfit = 50000,
  th1.v = c(0.2, 0.75),
  th2.v = NULL,
  niter = 5,
  tol = 0.001
)
}
\arguments{
\item{beta.v}{\code{double} vector consisting of beta values. Missing values (\code{NA}s) cannot be handled, so
these must be removed or imputed prior to running BMIQ. Before normalization, beta values that are
exactly 0 and exactly 1 are replaced by the minimum positive and maximum value below 1, respectively.}

\item{design.v}{\code{integer} vector of length \code{length(beta.v)}, containing the values \code{1} and \code{2}
only. These values specify probe design type.}

\item{doH}{Flag indicating if normalization for hemimethylated type II probes is to be performed.}

\item{nfit}{Number of probes of a given design to use for the fitting. Smaller values will make BMIQ faster at
the expense of accuracy. Values between 10000 and 50000 seem to work well.}

\item{th1.v}{Thresholds "type 1" to use for the initialization of the EM algorithm. These values should represent
best guesses for calling type I probes hemi-methylated and methylated, and are refined in further
steps by the algorithm.}

\item{th2.v}{Thresholds "type 2" to used for the initialization of the EM algorithm. These values should represent
best guesses for calling type II probes hemi-methylated and methylated, and are refined in further
steps by the EM algorithm. If this is \code{NULL} (default), the thresholds are estimated based on
\code{th1.v} and a modified PBC correction method.}

\item{niter}{Maximum number of EM iterations to be performed.}

\item{tol}{Tolerance threshold for EM algorithm.}
}
\value{
List with the following elements:
        \describe{
          \item{\code{"all"}}{The normalised beta-profile for the sample.}
          \item{\code{"class1"}}{Methylation state assigned to the type I probes.}
          \item{\code{"class2"}}{Methylation state assigned to the type II probes.}
          \item{\code{"av1"}}{Mean beta values for the \code{nL} classes for type I probes.}
          \item{\code{"av2"}}{Mean beta values for the \code{nL} classes for type II probes.}
          \item{\code{"hf"}}{Hubble dilation factor.}
          \item{\code{"th1"}}{Estimated thresholds used for type I probes.}
          \item{\code{"th2"}}{Estimated thresholds used for type II probes.}
        }
}
\description{
This function makes 3 indipendent attempts to fit a 3-state beta mixture model on the provided type I
             probes. An attempt is successful if at least 4 probes are assigned to each level. In case all attempts
             fail, the return value is \code{NULL}.
}
\details{
Performs Beta-mixture quantile normalization, adjusting for type II bias in Infinium 450K data.
}
\author{
Andrew Teschendorff and Steve Horvath; with minor modifications by Yassen Assenov
}
