########################################################################################################################
## ReportPlot-class.R
## created: 2012-04-16
## creator: Yassen Assenov
## ---------------------------------------------------------------------------------------------------------------------
## ReportPlot class definition.
########################################################################################################################

## C L A S S ###########################################################################################################

#' ReportPlot Class
#'
#' Information about the files created to store one generated plot in a report. Report plots are initialized using the
#' function \code{\link{createReportPlot}}.
#'
#' @section Slots:
#' \describe{
#'   \item{\code{fname}}{Relative file name. It does not include path or extension.}
#'   \item{\code{width}}{Width of the image in inches.}
#'   \item{\code{height}}{Height of the image in inches.}
#'   \item{\code{create.pdf}}{Flag indicating if a PDF image is created.}
#'   \item{\code{low.png}}{Resolution, in dots per inch, used for the figure image.}
#'   \item{\code{high.png}}{Resolution, in dots per inch, used for the high-resolution image.}
#'   \item{\code{dir.pdf}}{Directory that contains the generated PDF file.}
#'   \item{\code{dir.png.low}}{Directory that contains the generated figure image file.}
#'   \item{\code{dir.png.high}}{Directory that contains the generated high-resolution image file.}
#' }
#'
#' @section Methods and Functions:
#' \describe{
#'   \item{\code{\link{get.files}}}{Gets the list of all files that are planned to be generated,
#'        or were already generated by the report plot.}
#'   \item{\code{\link[=off,ReportPlot-method]{off}}}{Copies the figure to a PNG file (if needed) and closes the device
#'        associated with the report plot.}
#' }
#'
#' @name ReportPlot-class
#' @rdname ReportPlot-class
#' @aliases initialize,ReportPlot-method
#' @author Yassen Assenov
#' @exportClass ReportPlot
setClass("ReportPlot",
	representation(fname = "character", width = "numeric", height = "numeric",
		create.pdf = "logical", low.png = "integer", high.png = "integer",
		dir.pdf = "character", dir.png.low = "character", dir.png.high = "character"),
	prototype = prototype(fname = "temp", width = 7, height = 7,
		create.pdf = TRUE, low.png = as.integer(100), high.png = as.integer(0),
		dir.pdf = ".", dir.png.low = ".", dir.png.high = "."),
	package = "RnBeads")


#' ReportGgPlot Class
#'
#' Information about the files created to store one generated plot in a report. Report plots are initialized using the
#' function \code{\link{createReportGgPlot}}. It inherits from the \code{\linkS4class{ReportPlot}} class and handling is
#' analogous, except that it contains an additional slot to store a \code{ggplot} object.
#'
#' @section Slots:
#' \describe{
#'   \item{\code{ggp}}{\code{ggplot} object to be printed}
#' }
#' @section Notes:
#' No device is being opened until \code{off(reportGgPlot)} is called.
#'
#' @name ReportGgPlot-class
#' @rdname ReportGgPlot-class
#' @aliases initialize,ReportGgPlot-method
#' @author Fabian Mueller
#' @exportClass ReportGgPlot
setClass("ReportGgPlot",
		slots= c(ggp="ANY"),
		contains="ReportPlot",
		prototype = prototype(ggp=ggplot()),
		package = "RnBeads")
