% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankCenterByEntropy.R
\name{RankCenterByEntropy}
\alias{RankCenterByEntropy}
\title{Automatically rank ROI centers based on entropy}
\usage{
RankCenterByEntropy(
  sce,
  weight,
  enhanced = FALSE,
  selectN = round(length(sce$spot)/10),
  label = "celltype",
  topN = 10,
  min_radius = 10,
  avern = 5,
  radius_vec = c(10, 15, 20),
  doPlot = TRUE
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{weight}{A data frame to specify the weights of all cell types.}

\item{enhanced}{A logical variable of whether using enhanced data.}

\item{selectN}{A total number for selected centers. Should be smaller than the total site number.}

\item{label}{A variable name that contains the cell type information.}

\item{topN}{A number to specify the total amount of top ranked ROIs.}

\item{min_radius}{The minimum repellent radius.}

\item{avern}{A number of the average sites used to compute unit distance, default is 5.}

\item{radius_vec}{A vector of numbers for candidate radiuses.}

\item{doPlot}{Logical variable about whether draw the plot.}
}
\value{
An sce object with selected ROI information.
}
\description{
Automatically rank ROI centers based on entropy
}
\examples{
data("example_sce")
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
weight <- data.frame(celltype = c("Cancer Epithelial", "CAFs", "T-cells", "Endothelial",
                                  "PVL", "Myeloid", "B-cells", "Normal Epithelial", "Plasmablasts"),
                     weight = c(0.25,0.05,
                                0.25,0.05,
                                0.025,0.05,
                                0.25,0.05,0.025))
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
example_sce$"array_col" <- example_sce$col
example_sce$"array_row" <- example_sce$row
example_sce$"pxl_col_in_fullres" <- example_sce$imagecol
example_sce$"pxl_row_in_fullres" <- example_sce$imagerow
example_sce <- RankCenterByEntropy(example_sce, weight, label = "celltype",
                                  selectN = round(length(example_sce$spot)/10),
                                  topN = 3, min_radius = 10,
                                  radius_vec = c(10,15),
                                  doPlot = TRUE)

}
